/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.data;

import java.util.Locale;
import slimeknights.mantle.recipe.helper.FluidOutput;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.data.recipe.IByproduct;

public enum Byproduct implements IByproduct
{
    COPPER(true, (FluidObject<?>)TinkerFluids.moltenCopper),
    IRON(true, (FluidObject<?>)TinkerFluids.moltenIron),
    GOLD(true, (FluidObject<?>)TinkerFluids.moltenGold),
    SMALL_GOLD("gold", true, (FluidObject<?>)TinkerFluids.moltenGold, 30),
    COBALT(true, (FluidObject<?>)TinkerFluids.moltenCobalt),
    TIN(false, (FluidObject<?>)TinkerFluids.moltenTin),
    SILVER(false, (FluidObject<?>)TinkerFluids.moltenSilver),
    NICKEL(false, (FluidObject<?>)TinkerFluids.moltenNickel),
    LEAD(false, (FluidObject<?>)TinkerFluids.moltenLead),
    PLATINUM("platinum", false, (FluidObject<?>)TinkerFluids.moltenPlatinum, 30),
    DIAMOND("diamond", true, (FluidObject<?>)TinkerFluids.moltenDiamond, 100),
    AMETHYST("amethyst", true, (FluidObject<?>)TinkerFluids.moltenAmethyst, 100),
    QUARTZ("quartz", true, (FluidObject<?>)TinkerFluids.moltenQuartz, 100);

    private final String name;
    private final boolean alwaysPresent;
    private final FluidObject<?> fluid;
    private final int amount;

    private Byproduct(boolean alwaysPresent, FluidObject<?> fluid) {
        this.name = this.name().toLowerCase(Locale.ROOT);
        this.alwaysPresent = alwaysPresent;
        this.fluid = fluid;
        this.amount = 90;
    }

    @Override
    public FluidOutput getFluid(float scale) {
        return this.fluid.result((int)((float)this.amount * scale));
    }

    private Byproduct(String name, boolean alwaysPresent, FluidObject<?> fluid, int amount) {
        this.name = name;
        this.alwaysPresent = alwaysPresent;
        this.fluid = fluid;
        this.amount = amount;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isAlwaysPresent() {
        return this.alwaysPresent;
    }

    public FluidObject<?> getFluid() {
        return this.fluid;
    }

    public int getAmount() {
        return this.amount;
    }
}

